<?xml version="1.0" encoding="UTF-8"?>
    <pattern xmlns="http://purl.oclc.org/dsdl/schematron" abstract="true" id="template_NOTIFY_EMAIL_SUBJECT">
        <title>Email notificaiton subject template</title>
        <rule context="$element">
            <assert role="error" test="hl7:subject"
                >subject is verplicht: er moet een relatie zijn naar de patient</assert>
            <assert role="error" test="@moodCode='RQO'">@moodCode moet 'RQO' bevatten</assert>
        </rule>
        <rule context="$element/hl7:code">
            <extends rule="CV"/>
            <assert role="error" test="@code='NOTIFY_EMAIL' and @codeSystem='2.16.840.1.113883.2.4.3.11.17.2'"
                >template_NOTIFY_EMAIL: @code moet 'NOTIFY_EMAIL' bevatten uit codeSystem '2.16.840.1.113883.2.4.3.11.17.2'</assert>
        </rule>
        <rule context="$element/hl7:effectiveTime">
            <assert role="error" test="not(exists(.))"
                >template_NOTIFY_EMAIL: effectiveTime niet gebruiken</assert>
        </rule>
        <rule context="$element[hl7:value/@value='false']/hl7:component">
            <assert role="error" test="not(exists(.))"
                >template_NOTIFY_EMAIL: component niet gebruiken wanneer geen notificaties gewenst zijn</assert>
        </rule>
        <rule context="$element[hl7:value/@value='true']">
            <extends rule="BL"/>
            <assert role="error" test="exists(hl7:component)"
                >template_NOTIFY_EMAIL: component is verplicht wanneer notificaties gewenst zijn</assert>
        </rule>
        <rule context="$element[hl7:value/@value='true']/hl7:component/hl7:preference">
            <assert role="error" test="@moodCode='EVN'">@moodCode moet 'EVN' bevatten</assert>
        </rule>   
        <rule context="$element[hl7:value/@value='true']/hl7:component/hl7:preference/hl7:templateId">
            <assert role="error" test="not(exists(.))"
                >template_NOTIFY_EMAIL: templateId niet gebruiken bij subpreference</assert>
        </rule>
        <rule context="$element[hl7:value/@value='true']/hl7:component/hl7:preference/hl7:code">
            <extends rule="CV"/>
            <assert role="error" test="@code='EMAIL' and @codeSystem='2.16.840.1.113883.2.4.3.11.17.3'"
                >template_NOTIFY_EMAIL: @code moet 'EMAIL' bevatten uit codeSystem '2.16.840.1.113883.2.4.3.11.17.3'</assert>
        </rule>
        <rule context="$element[hl7:value/@value='true']/hl7:component/hl7:preference/hl7:effectiveTime">
            <extends rule="PIVL_TS"/>
            <assert role="error" test="@xsi:type='PIVL_TS'"
                >template_NOTIFY_EMAIL: het datatype van effectiveTime moet 'PIVL_TS' zijn</assert>
            <assert role="error" test="exists(hl7:period)"
                >template_NOTIFY_EMAIL: effectiveTime moet een period element hebben</assert>
        </rule>
        <rule context="$element[hl7:value/@value='true']/hl7:component/hl7:preference/hl7:effectiveTime/hl7:period">
            <assert role="error" test="@unit='d'"
                >template_NOTIFY_EMAIL: de unit van period moet dag zijn</assert>
        </rule>
        
        <rule context="$element[hl7:value/@value='true']/hl7:component/hl7:preference/hl7:value">
            <extends rule="TEL"/>
            <assert role="error" test="@xsi:type='TEL'"
                >template_NOTIFY_EMAIL: het datatype van value moet 'TEL' zijn</assert>
            <assert role="error" test=" starts-with(@value,'mailto:')"
                >template_NOTIFY_EMAIL: het url scheme moet 'mailto' zijn</assert>
        </rule>
        <rule context="$element[hl7:value/@value='true']/hl7:component/hl7:preference/hl7:subject">
            <assert role="error" test="not(exists(.))"
                >template_NOTIFY_EMAIL: subject bij subpreference niet gebruiken</assert>
        </rule>
        <rule context="$element[hl7:value/@value='true']/hl7:component/hl7:preference/hl7:component">
            <assert role="error" test="not(exists(.))"
                >template_NOTIFY_EMAIL: component van subpreference niet gebruiken</assert>
        </rule>
        

        
    </pattern>

